<?php

return [

    /* -----------------------------------------------------------------
     |  Settings
     | -----------------------------------------------------------------
     */

    'supported-locales'      => ['en', 'es', 'fr'],

    'accept-language-header' => true,

    'hide-default-in-url'    => false,

    'redirection-code'       => 302,

    'utf-8-suffix'           => '.UTF-8',

    /* -----------------------------------------------------------------
     |  Route
     | -----------------------------------------------------------------
     */

    'route'                  => [
        'middleware' => [
            'localization-session-redirect' => true,
            'localization-cookie-redirect'  => false,
            'localization-redirect'         => true,
            'localized-routes'              => true,
            'translation-redirect'          => true,
        ],
    ],

    /* -----------------------------------------------------------------
     |  Ignored URI/Route from localization
     | -----------------------------------------------------------------
     */

    'ignored-redirection' => [
        //
    ],

    /* -----------------------------------------------------------------
     |  Locales
     | -----------------------------------------------------------------
     */

    'locales'   => [
        // A
        //====================================================>
        'aa'          => [
            'name'     => 'Afar',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Qafar',
            'regional' => 'aa_ER',
        ],
        'ab'          => [
            'name'     => 'Abkhazian',
            'script'   => 'Cyrl',
            'dir'      => 'ltr',
            'native'   => 'Аҧсуа',
            'regional' => '',
        ],
        'ace'         => [
            'name'     => 'Achinese',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Aceh',
            'regional' => '',
        ],
        'ady'         => [
            'name'     => 'Adyghe',
            'script'   => 'Cyrl',
            'dir'      => 'ltr',
            'native'   => 'Адыгэбзэ',
            'regional' => '',
        ],
        'ae'          => [
            'name'     => 'Avestan',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Avesta',
            'regional' => '',
        ],
        'af'          => [
            'name'     => 'Afrikaans',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Afrikaans',
            'regional' => 'af_ZA',
        ],
        'agq'         => [
            'name'     => 'Aghem',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Aghem',
            'regional' => '',
        ],
        'ak'          => [
            'name'     => 'Akan',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Akan',
            'regional' => 'ak_GH',
        ],
        'ale'         => [
            'name'     => 'Aleut',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Unangax tunuu',
            'regional' => '',
        ],
        'am'          => [
            'name'     => 'Amharic',
            'script'   => 'Ethi',
            'dir'      => 'ltr',
            'native'   => 'አማርኛ',
            'regional' => 'am_ET',
        ],
        'an'          => [
            'name'     => 'Aragonese',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Aragonés',
            'regional' => 'an_ES',
        ],
        'ang'         => [
            'name'     => 'Old English',
            'script'   => 'Runr',
            'dir'      => 'ltr',
            'native'   => 'Old English',
            'regional' => '',
        ],
        'ar'          => [
            'name'     => 'Arabic',
            'script'   => 'Arab',
            'dir'      => 'rtl',
            'native'   => 'العربية',
            'regional' => 'ar_AE',
        ],
        'as'          => [
            'name'     => 'Assamese',
            'script'   => 'Beng',
            'dir'      => 'ltr',
            'native'   => 'অসমীয়া',
            'regional' => 'as_IN',
        ],
        'asa'         => [
            'name'     => 'Kipare',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Kipare',
            'regional' => '',
        ],
        'av'          => [
            'name'     => 'Avaric',
            'script'   => 'Cyrl',
            'dir'      => 'ltr',
            'native'   => 'Авар мацӀ',
            'regional' => '',
        ],
        'ay'          => [
            'name'     => 'Aymara',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Aymar aru',
            'regional' => 'ay_PE',
        ],
        'az'          => [
            'name'     => 'Azerbaijani (Latin)',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Azərbaycanca',
            'regional' => 'az_AZ',
        ],
        'az-Cyrl'     => [
            'name'     => 'Azerbaijani (Cyrillic)',
            'script'   => 'Cyrl',
            'dir'      => 'ltr',
            'native'   => 'Азәрбајҹан',
            'regional' => 'uz_UZ',
        ],

        // B
        //====================================================>
        'ba'          => [
            'name'     => 'Bashkir',
            'script'   => 'Cyrl',
            'dir'      => 'ltr',
            'native'   => 'Башҡорт теле',
            'regional' => '',
        ],
        'bas'         => [
            'name'     => 'Basa',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Ɓàsàa',
            'regional' => '',
        ],
        'be'          => [
            'name'     => 'Belarusian',
            'script'   => 'Cyrl',
            'dir'      => 'ltr',
            'native'   => 'Беларуская',
            'regional' => 'be_BY',
        ],
        'bem'         => [
            'name'     => 'Bemba',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Ichibemba',
            'regional' => 'bem_ZM',
        ],
        'bez'         => [
            'name'     => 'Bena',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Hibena',
            'regional' => '',
        ],
        'bg'          => [
            'name'     => 'Bulgarian',
            'script'   => 'Cyrl',
            'dir'      => 'ltr',
            'native'   => 'Български',
            'regional' => 'bg_BG',
        ],
        'bh'          => [
            'name'     => 'Bihari',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Bihari',
            'regional' => '',
        ],
        'bi'          => [
            'name'     => 'Bislama',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Bislama',
            'regional' => '',
        ],
        'bm'          => [
            'name'     => 'Bambara',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Bamanakan',
            'regional' => '',
        ],
        'bn'          => [
            'name'     => 'Bengali',
            'script'   => 'Beng',
            'dir'      => 'ltr',
            'native'   => 'বাংলা',
            'regional' => 'bn_BD',
        ],
        'bo'          => [
            'name'     => 'Tibetan',
            'script'   => 'Tibt',
            'dir'      => 'ltr',
            'native'   => 'པོད་སྐད་',
            'regional' => 'bo_IN',
        ],
        'br'          => [
            'name'     => 'Breton',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Brezhoneg',
            'regional' => 'br_FR',
        ],
        'bra'         => [
            'name'     => 'Braj',
            'script'   => 'Deva',
            'dir'      => 'ltr',
            'native'   => 'ब्रज भाषा',
            'regional' => '',
        ],
        'brx'         => [
            'name'     => 'Bodo',
            'script'   => 'Deva',
            'dir'      => 'ltr',
            'native'   => 'बड़ो',
            'regional' => 'brx_IN',
        ],
        'bs'          => [
            'name'     => 'Bosnian',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Bosanski',
            'regional' => 'bs_BA',
        ],
        'byn'         => [
            'name'     => 'Blin',
            'script'   => 'Ethi',
            'dir'      => 'ltr',
            'native'   => 'ብሊን',
            'regional' => 'byn_ER',
        ],

        // C
        //====================================================>
        'ca'          => [
            'name'     => 'Catalan',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Català',
            'regional' => 'ca_ES',
        ],
        'ca-valencia' => [
            'name'     => 'Valencian',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Valencià',
            'regional' => '',
        ],
        'cch'         => [
            'name'     => 'Atsam',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Atsam',
            'regional' => '',
        ],
        'ce'          => [
            'name'     => 'Chechen',
            'script'   => 'Cyrl',
            'dir'      => 'ltr',
            'native'   => 'Нохчийн мотт',
            'regional' => 'ce_RU',
        ],
        'cgg'         => [
            'name'     => 'Chiga',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Rukiga',
            'regional' => '',
        ],
        'ch'          => [
            'name'     => 'Chamorro',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Chamoru',
            'regional' => '',
        ],
        'chr'         => [
            'name'     => 'Cherokee',
            'script'   => 'Cher',
            'dir'      => 'ltr',
            'native'   => 'ᏣᎳᎩ',
            'regional' => '',
        ],
        'co'          => [
            'name'     => 'Corsican',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Corsu',
            'regional' => '',
        ],
        'cr'          => [
            'name'     => 'Cree',
            'script'   => 'Cans',
            'dir'      => 'ltr',
            'native'   => 'ᓀᐦᐃᔭᐍᐏᐣ',
            'regional' => '',
        ],
        'cs'          => [
            'name'     => 'Czech',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Čeština',
            'regional' => 'cs_CZ',
        ],
        'cu'          => [
            'name'     => 'Church Slavic',
            'script'   => 'Cyrl',
            'dir'      => 'ltr',
            'native'   => 'Ѩзыкъ словѣньскъ',
            'regional' => '',
        ],
        'cv'          => [
            'name'     => 'Chuvash',
            'script'   => 'Cyrl',
            'dir'      => 'ltr',
            'native'   => 'Чӑваш чӗлхи',
            'regional' => 'cv_RU',
        ],
        'cy'          => [
            'name'     => 'Welsh',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Cymraeg',
            'regional' => 'cy_GB',
        ],

        // D
        //====================================================>
        'da'          => [
            'name'     => 'Danish',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Dansk',
            'regional' => 'da_DK',
        ],
        'dav'         => [
            'name'     => 'Dawida',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Kitaita',
            'regional' => '',
        ],
        'de'          => [
            'name'     => 'German',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Deutsch',
            'regional' => 'de_DE',
        ],
        'de-AT'       => [
            'name'     => 'Austrian German',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Österreichisches Deutsch',
            'regional' => 'de_AT',
        ],
        'de-CH'       => [
            'name'     => 'Swiss High German',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Schweizer Hochdeutsch',
            'regional' => 'de_CH',
        ],
        'dje'         => [
            'name'     => 'Zarma',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Zarmaciine',
            'regional' => '',
        ],
        'doi'         => [
            'name'     => 'Dogri',
            'script'   => 'Deva',
            'dir'      => 'ltr',
            'native'   => 'डोगरी',
            'regional' => 'doi_IN',
        ],
        'dua'         => [
            'name'     => 'Duala',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Duálá',
            'regional' => '',
        ],
        'dv'          => [
            'name'     => 'Divehi',
            'script'   => 'Thaa',
            'dir'      => 'rtl',
            'native'   => 'ދިވެހިބަސް',
            'regional' => 'dv_MV',
        ],
        'dyo'         => [
            'name'     => 'Jola-Fonyi',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Joola',
            'regional' => '',
        ],
        'dz'          => [
            'name'     => 'Dzongkha',
            'script'   => 'Tibt',
            'dir'      => 'ltr',
            'native'   => 'རྫོང་ཁ',
            'regional' => 'dz_BT',
        ],

        // E
        //====================================================>
        'ebu'         => [
            'name'     => 'Kiembu',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Kĩembu',
            'regional' => '',
        ],
        'ee'          => [
            'name'     => 'Ewe',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Eʋegbe',
            'regional' => '',
        ],
        'en'          => [
            'name'     => 'English',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'English',
            'regional' => 'en_GB',
        ],
        'en-AU'       => [
            'name'     => 'Australian English',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Australian English',
            'regional' => 'en_AU',
        ],
        'en-GB'       => [
            'name'     => 'British English',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'British English',
            'regional' => 'en_GB',
        ],
        'en-US'       => [
            'name'     => 'U.S. English',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'U.S. English',
            'regional' => 'en_US',
        ],
        'el'          => [
            'name'     => 'Greek',
            'script'   => 'Grek',
            'dir'      => 'ltr',
            'native'   => 'Ελληνικά',
            'regional' => 'el_GR',
        ],
        'eo'          => [
            'name'     => 'Esperanto',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Esperanto',
            'regional' => '',
        ],
        'es'          => [
            'name'     => 'Spanish',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Español',
            'regional' => 'es_ES',
        ],
        'et'          => [
            'name'     => 'Estonian',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Eesti',
            'regional' => 'et_EE',
        ],
        'eu'          => [
            'name'     => 'Basque',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Euskara',
            'regional' => 'eu_ES',
        ],
        'ewo'         => [
            'name'     => 'Ewondo',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Ewondo',
            'regional' => '',
        ],

        // F
        //====================================================>
        'fa'          => [
            'name'     => 'Persian',
            'script'   => 'Arab',
            'dir'      => 'rtl',
            'native'   => 'فارسی',
            'regional' => 'fa_IR',
        ],
        'ff'          => [
            'name'     => 'Fulah',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Pulaar',
            'regional' => 'ff_SN',
        ],
        'fi'          => [
            'name'     => 'Finnish',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Suomi',
            'regional' => 'fi_FI',
        ],
        'fil'         => [
            'name'     => 'Filipino',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Filipino',
            'regional' => 'fil_PH',
        ],
        'fj'          => [
            'name'     => 'Fijian',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Vosa Vakaviti',
            'regional' => '',
        ],
        'fo'          => [
            'name'     => 'Faroese',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Føroyskt',
            'regional' => 'fo_FO',
        ],
        'fr'          => [
            'name'     => 'French',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Français',
            'regional' => 'fr_FR',
        ],
        'fr-CA'       => [
            'name'     => 'Canadian French',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Français canadien',
            'regional' => 'fr_CA',
        ],
        'fur'         => [
            'name'     => 'Friulian',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Furlan',
            'regional' => 'fur_IT',
        ],
        'fy'          => [
            'name'     => 'Western Frisian',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Frysk',
            'regional' => 'fy_DE',
        ],

        // G
        //====================================================>
        'ga'          => [
            'name'     => 'Irish',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Gaeilge',
            'regional' => 'ga_IE',
        ],
        'gaa'         => [
            'name'     => 'Ga',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Ga',
            'regional' => '',
        ],
        'gd'          => [
            'name'     => 'Scottish Gaelic',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Gàidhlig',
            'regional' => 'gd_GB',
        ],
        'gl'          => [
            'name'     => 'Galician',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Galego',
            'regional' => 'gl_ES',
        ],
        'gn'          => [
            'name'     => 'Guaraní',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Avañe’ẽ',
            'regional' => '',
        ],
        'gsw'         => [
            'name'     => 'Swiss German',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Schwiizertüütsch',
            'regional' => '',
        ],
        'gu'          => [
            'name'     => 'Gujarati',
            'script'   => 'Gujr',
            'dir'      => 'ltr',
            'native'   => 'ગુજરાતી',
            'regional' => 'gu_IN',
        ],
        'guz'         => [
            'name'     => 'Ekegusii',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Ekegusii',
            'regional' => '',
        ],
        'gv'          => [
            'name'     => 'Manx',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Gaelg',
            'regional' => 'gv_GB',
        ],

        // H
        //====================================================>
        'ha'          => [
            'name'     => 'Hausa',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Hausa',
            'regional' => 'ha_NG',
        ],
        'haw'         => [
            'name'     => 'Hawaiian',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'ʻŌlelo Hawaiʻi',
            'regional' => '',
        ],
        'he'          => [
            'name'     => 'Hebrew',
            'script'   => 'Hebr',
            'dir'      => 'rtl',
            'native'   => 'עברית',
            'regional' => 'he_IL',
        ],
        'hi'          => [
            'name'     => 'Hindi',
            'script'   => 'Deva',
            'dir'      => 'ltr',
            'native'   => 'हिन्दी',
            'regional' => 'hi_IN',
        ],
        'ho'          => [
            'name'     => 'Hiri Motu',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Hiri Motu',
            'regional' => '',
        ],
        'hr'          => [
            'name'     => 'Croatian',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Hrvatski',
            'regional' => 'hr_HR',
        ],
        'ht'          => [
            'name'     => 'Haitian',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Kreyòl ayisyen',
            'regional' => 'ht_HT',
        ],
        'hu'          => [
            'name'     => 'Hungarian',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Magyar',
            'regional' => 'hu_HU',
        ],
        'hy'          => [
            'name'     => 'Armenian',
            'script'   => 'Armn',
            'dir'      => 'ltr',
            'native'   => 'Հայերէն',
            'regional' => 'hy_AM',
        ],
        'hz'          => [
            'name'     => 'Herero',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Otjiherero',
            'regional' => '',
        ],

        // I
        //====================================================>
        'ia'          => [
            'name'     => 'Interlingua',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Interlingua',
            'regional' => 'ia_FR',
        ],
        'id'          => [
            'name'     => 'Indonesian',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Bahasa Indonesia',
            'regional' => 'id_ID',
        ],
        'ig'          => [
            'name'     => 'Igbo',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Igbo',
            'regional' => 'ig_NG',
        ],
        'ii'          => [
            'name'     => 'Sichuan Yi',
            'script'   => 'Yiii',
            'dir'      => 'ltr',
            'native'   => 'ꆈꌠꉙ',
            'regional' => '',
        ],
        'ik'          => [
            'name'     => 'Inupiaq',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Iñupiaq',
            'regional' => 'ik_CA',
        ],
        'io'          => [
            'name'     => 'Ido',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Ido',
            'regional' => '',
        ],
        'is'          => [
            'name'     => 'Icelandic',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Íslenska',
            'regional' => 'is_IS',
        ],
        'it'          => [
            'name'     => 'Italian',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Italiano',
            'regional' => 'it_IT',
        ],
        'iu'          => [
            'name'     => 'Inuktitut (Canadian Aboriginal Syllabics)',
            'script'   => 'Cans',
            'dir'      => 'ltr',
            'native'   => 'ᐃᓄᒃᑎᑐᑦ',
            'regional' => 'iu_CA',
        ],
        'iu-Latin'    => [
            'name'     => 'Inuktitut (Latin)',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Inuktitut',
            'regional' => 'ia_FR',
        ],

        // J
        //====================================================>
        'ja'          => [
            'name'     => 'Japanese',
            'script'   => 'Jpan',
            'dir'      => 'ltr',
            'native'   => '日本語',
            'regional' => 'ja_JP',
        ],
        'jmc'         => [
            'name'     => 'Machame',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Kimachame',
            'regional' => '',
        ],
        'jv'          => [
            'name'     => 'Javanese (Latin)',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Basa Jawa',
            'regional' => '',
        ],
        'jv-Java'     => [
            'name'     => 'Javanese (Javanese)',
            'script'   => 'Java',
            'dir'      => 'ltr',
            'native'   => 'ꦧꦱꦗꦮ',
            'regional' => '',
        ],

        // K
        //====================================================>
        'ka'          => [
            'name'     => 'Georgian',
            'script'   => 'Geor',
            'dir'      => 'ltr',
            'native'   => 'ქართული',
            'regional' => 'ka_GE',
        ],
        'kab'         => [
            'name'     => 'Kabyle',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Taqbaylit',
            'regional' => 'kab_DZ',
        ],
        'kaj'         => [
            'name'     => 'Jju',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Kaje',
            'regional' => '',
        ],
        'kam'         => [
            'name'     => 'Kamba',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Kikamba',
            'regional' => '',
        ],
        'kcg'         => [
            'name'     => 'Tyap',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Katab',
            'regional' => '',
        ],
        'kde'         => [
            'name'     => 'Makonde',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Chimakonde',
            'regional' => '',
        ],
        'kea'         => [
            'name'     => 'Kabuverdianu',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Kabuverdianu',
            'regional' => '',
        ],
        'kg'          => [
            'name'     => 'Kongo',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Kikongo',
            'regional' => '',
        ],
        'khq'         => [
            'name'     => 'Koyra Chiini',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Koyra ciini',
            'regional' => '',
        ],
        'ki'          => [
            'name'     => 'Kikuyu',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Gikuyu',
            'regional' => '',
        ],
        'kj'          => [
            'name'     => 'Kuanyama',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Kwanyama',
            'regional' => '',
        ],
        'kk'          => [
            'name'     => 'Kazakh',
            'script'   => 'Cyrl',
            'dir'      => 'ltr',
            'native'   => 'Қазақ тілі',
            'regional' => 'kk_KZ',
        ],
        'kl'          => [
            'name'     => 'Kalaallisut',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Kalaallisut',
            'regional' => 'kl_GL',
        ],
        'kln'         => [
            'name'     => 'Kalenjin',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Kalenjin',
            'regional' => '',
        ],
        'km'          => [
            'name'     => 'Khmer',
            'script'   => 'Khmr',
            'dir'      => 'ltr',
            'native'   => 'ភាសាខ្មែរ',
            'regional' => 'km_KH',
        ],
        'kn'          => [
            'name'     => 'Kannada',
            'script'   => 'Knda',
            'dir'      => 'ltr',
            'native'   => 'ಕನ್ನಡ',
            'regional' => 'kn_IN',
        ],
        'ko'          => [
            'name'     => 'Korean',
            'script'   => 'Hang',
            'dir'      => 'ltr',
            'native'   => '한국어',
            'regional' => 'ko_KR',
        ],
        'kok'         => [
            'name'     => 'Konkani',
            'script'   => 'Deva',
            'dir'      => 'ltr',
            'native'   => 'कोंकणी',
            'regional' => 'kok_IN',
        ],
        'kr'          => [
            'name'     => 'Kanuri',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Kanuri',
            'regional' => '',
        ],
        'ks'          => [
            'name'     => 'Kashmiri (Arabic)',
            'script'   => 'Arab',
            'dir'      => 'rtl',
            'native'   => 'کأشُر',
            'regional' => 'ks_IN',
        ],
        'ks-Deva'     => [
            'name'     => 'Kashmiri (Devaganari)',
            'script'   => 'Deva',
            'dir'      => 'ltr',
            'native'   => 'कॉशुर',
            'regional' => 'ks_IN',
        ],
        'ksb'         => [
            'name'     => 'Shambala',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Kishambaa',
            'regional' => '',
        ],
        'ksf'         => [
            'name'     => 'Bafia',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Rikpa',
            'regional' => '',
        ],
        'ksh'         => [
            'name'     => 'Kölsch',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Kölsch',
            'regional' => '',
        ],
        'ku'          => [
            'name'     => 'Kurdish',
            'script'   => 'Arab',
            'dir'      => 'rtl',
            'native'   => 'کوردی',
            'regional' => 'ku_TR',
        ],
        'kv'          => [
            'name'     => 'Komi',
            'script'   => 'Cyrl',
            'dir'      => 'ltr',
            'native'   => 'Коми кыв',
            'regional' => '',
        ],
        'kw'          => [
            'name'     => 'Cornish',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Kernewek',
            'regional' => 'kw_GB',
        ],
        'ky'          => [
            'name'     => 'Kyrgyz',
            'script'   => 'Cyrl',
            'dir'      => 'ltr',
            'native'   => 'Кыргыз',
            'regional' => 'ky_KG',
        ],

        // L
        //====================================================>
        'la'          => [
            'name'     => 'Latin',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Latine',
            'regional' => '',
        ],
        'lag'         => [
            'name'     => 'Langi',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Kɨlaangi',
            'regional' => '',
        ],
        'lah'         => [
            'name'     => 'Lahnda',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Lahnda',
            'regional' => '',
        ],
        'lb'          => [
            'name'     => 'Luxembourgish',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Lëtzebuergesch',
            'regional' => 'lb_LU',
        ],
        'lg'          => [
            'name'     => 'Ganda',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Luganda',
            'regional' => 'lg_UG',
        ],
        'li'          => [
            'name'     => 'Limburgish',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Limburgs',
            'regional' => 'li_BE',
        ],
        'ln'          => [
            'name'     => 'Lingala',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Lingála',
            'regional' => '',
        ],
        'lo'          => [
            'name'     => 'Lao',
            'script'   => 'Laoo',
            'dir'      => 'ltr',
            'native'   => 'ລາວ',
            'regional' => 'lo_LA',
        ],
        'lt'          => [
            'name'     => 'Lithuanian',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Lietuvių',
            'regional' => 'lt_LT',
        ],
        'lu'          => [
            'name'     => 'Luba-Katanga',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Tshiluba',
            'regional' => '',
        ],
        'luo'         => [
            'name'     => 'Luo',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Dholuo',
            'regional' => '',
        ],
        'luy'         => [
            'name'     => 'Oluluyia',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Luluhia',
            'regional' => '',
        ],
        'lv'          => [
            'name'     => 'Latvian',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Latviešu',
            'regional' => 'lv_LV',
        ],

        // M
        //====================================================>
        'mai'         => [
            'name'     => 'Maithili',
            'script'   => 'Tirh',
            'dir'      => 'ltr',
            'native'   => 'मैथिली',
            'regional' => 'mai_IN',
        ],
        'mas'         => [
            'name'     => 'Masai',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Ɔl-Maa',
            'regional' => '',
        ],
        'mer'         => [
            'name'     => 'Kimîîru',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Kĩmĩrũ',
            'regional' => '',
        ],
        'mfe'         => [
            'name'     => 'Morisyen',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Kreol morisien',
            'regional' => '',
        ],
        'mg'          => [
            'name'     => 'Malagasy',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Malagasy',
            'regional' => 'mg_MG',
        ],
        'mgh'         => [
            'name'     => 'Makhuwa-Meetto',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Makua',
            'regional' => '',
        ],
        'mh'          => [
            'name'     => 'Marshallese',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Kajin M̧ajeļ',
            'regional' => 'mh_MH',
        ],
        'mi'          => [
            'name'     => 'Māori',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Māori',
            'regional' => 'mi_NZ',
        ],
        'mk'          => [
            'name'     => 'Macedonian',
            'script'   => 'Cyrl',
            'dir'      => 'ltr',
            'native'   => 'Македонски',
            'regional' => 'mk_MK',
        ],
        'ml'          => [
            'name'     => 'Malayalam',
            'script'   => 'Mlym',
            'dir'      => 'ltr',
            'native'   => 'മലയാളം',
            'regional' => 'ml_IN',
        ],
        'mn'          => [
            'name'     => 'Mongolian (Cyrillic)',
            'script'   => 'Cyrl',
            'dir'      => 'ltr',
            'native'   => 'Монгол',
            'regional' => 'mn_MN',
        ],
        'mn-Mong'     => [
            'name'     => 'Mongolian (Mongolian)',
            'script'   => 'Mong',
            'dir'      => 'rtl',
            'native'   => 'ᠮᠣᠨᠭᠭᠣᠯ ᠬᠡᠯᠡ',
            'regional' => 'mn_MN',
        ],
        'mni'         => [
            'name'     => 'Manipuri',
            'script'   => 'Beng',
            'dir'      => 'ltr',
            'native'   => 'মৈতৈ',
            'regional' => 'mni_IN',
        ],
        'mr'          => [
            'name'     => 'Marathi',
            'script'   => 'Deva',
            'dir'      => 'ltr',
            'native'   => 'मराठी',
            'regional' => 'mr_IN',
        ],
        'ms'          => [
            'name'     => 'Malay',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Bahasa Melayu',
            'regional' => 'ms_MY',
        ],
        'mt'          => [
            'name'     => 'Maltese',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Malti',
            'regional' => 'mt_MT',
        ],
        'mtr'         => [
            'name'     => 'Mewari',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Mewari',
            'regional' => '',
        ],
        'mua'         => [
            'name'     => 'Mundang',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Mundang',
            'regional' => '',
        ],
        'my'          => [
            'name'     => 'Burmese',
            'script'   => 'Mymr',
            'dir'      => 'ltr',
            'native'   => 'မြန်မာဘာသာ',
            'regional' => 'my_MM',
        ],

        // N
        //====================================================>
        'na'          => [
            'name'     => 'Nauru',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Ekakairũ Naoero',
            'regional' => '',
        ],
        'naq'         => [
            'name'     => 'Nama',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Khoekhoegowab',
            'regional' => '',
        ],
        'nb'          => [
            'name'     => 'Norwegian Bokmål',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Bokmål',
            'regional' => 'nb_NO',
        ],
        'nd'          => [
            'name'     => 'North Ndebele',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'IsiNdebele',
            'regional' => '',
        ],
        'nds'         => [
            'name'     => 'Low German',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Plattdüütsch',
            'regional' => 'nds_DE',
        ],
        'ne'          => [
            'name'     => 'Nepali',
            'script'   => 'Deva',
            'dir'      => 'ltr',
            'native'   => 'नेपाली',
            'regional' => '',
        ],
        'ng'          => [
            'name'     => 'Ndonga',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'OshiNdonga',
            'regional' => '',
        ],
        'nl'          => [
            'name'     => 'Dutch',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Nederlands',
            'regional' => 'nl_NL',
        ],
        'nmg'         => [
            'name'     => 'Kwasio',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Ngumba',
            'regional' => '',
        ],
        'nn'          => [
            'name'     => 'Norwegian Nynorsk',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Nynorsk',
            'regional' => 'nn_NO',
        ],
        'nr'          => [
            'name'     => 'South Ndebele',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'IsiNdebele',
            'regional' => 'nr_ZA',
        ],
        'nso'         => [
            'name'     => 'Northern Sotho',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Sesotho sa Leboa',
            'regional' => 'nso_ZA',
        ],
        'nus'         => [
            'name'     => 'Nuer',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Thok Nath',
            'regional' => '',
        ],
        'nv'          => [
            'name'     => 'Navajo',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Diné bizaad',
            'regional' => '',
        ],
        'ny'          => [
            'name'     => 'Chewa',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'ChiCheŵa',
            'regional' => '',
        ],
        'nyn'         => [
            'name'     => 'Nyankole',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Runyankore',
            'regional' => '',
        ],

        // O
        //====================================================>
        'oc'          => [
            'name'     => 'Occitan',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Occitan',
            'regional' => 'oc_FR',
        ],
        'oj'          => [
            'name'     => 'Ojibwa',
            'script'   => 'Cans',
            'dir'      => 'ltr',
            'native'   => 'ᐊᓂᔑᓈᐯᒧᐎᓐ',
            'regional' => '',
        ],
        'om'          => [
            'name'     => 'Oromo',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Oromoo',
            'regional' => 'om_ET',
        ],
        'or'          => [
            'name'     => 'Oriya',
            'script'   => 'Orya',
            'dir'      => 'ltr',
            'native'   => 'ଓଡ଼ିଆ',
            'regional' => 'or_IN',
        ],
        'os'          => [
            'name'     => 'Ossetic',
            'script'   => 'Cyrl',
            'dir'      => 'ltr',
            'native'   => 'Ирон',
            'regional' => 'os_RU',
        ],

        // P
        //====================================================>
        'pa'          => [
            'name'     => 'Punjabi (Gurmukhi)',
            'script'   => 'Guru',
            'dir'      => 'ltr',
            'native'   => 'ਪੰਜਾਬੀ',
            'regional' => 'pa_IN',
        ],
        'pa-Arab'     => [
            'name'     => 'Punjabi (Arabic)',
            'script'   => 'Arab',
            'dir'      => 'rtl',
            'native'   => 'پنجاب',
            'regional' => 'pa_IN',
        ],
        'pi'          => [
            'name'     => 'Pahari-Potwari',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Pāli',
            'regional' => '',
        ],
        'pl'          => [
            'name'     => 'Polish',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Polski',
            'regional' => 'pl_PL',
        ],
        'pra'         => [
            'name'     => 'Prakrit',
            'script'   => 'Deva',
            'dir'      => 'ltr',
            'native'   => 'प्राकृत',
            'regional' => '',
        ],
        'ps'          => [
            'name'     => 'Pashto',
            'script'   => 'Arab',
            'dir'      => 'rtl',
            'native'   => 'پښتو',
            'regional' => 'ps_AF',
        ],
        'pt'          => [
            'name'     => 'Portuguese',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Português',
            'regional' => 'pt_PT',
        ],
        'pt-BR'       => [
            'name'     => 'Brazilian Portuguese',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Português do Brasil',
            'regional' => 'pt_BR',
        ],

        // Q
        //====================================================>
        'qu'          => [
            'name'     => 'Quechua',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Runa Simi',
            'regional' => '',
        ],

        // R
        //====================================================>
        'raj'         => [
            'name'     => 'Rajasthani',
            'script'   => 'Deva',
            'dir'      => 'ltr',
            'native'   => 'राजस्थानी',
            'regional' => '',
        ],
        'ro'          => [
            'name'     => 'Romanian',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Română',
            'regional' => 'ro_RO',
        ],
        'rof'         => [
            'name'     => 'Rombo',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Kihorombo',
            'regional' => '',
        ],
        'rm'          => [
            'name'     => 'Romansh',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Rumantsch',
            'regional' => '',
        ],
        'rn'          => [
            'name'     => 'Rundi',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Ikirundi',
            'regional' => '',
        ],
        'ru'          => [
            'name'     => 'Russian',
            'script'   => 'Cyrl',
            'dir'      => 'ltr',
            'native'   => 'Русский',
            'regional' => 'ru_RU',
        ],
        'rw'          => [
            'name'     => 'Kinyarwanda',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Kinyarwanda',
            'regional' => 'rw_RW',
        ],
        'rwk'         => [
            'name'     => 'Rwa',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Kiruwa',
            'regional' => '',
        ],

        // S
        //====================================================>
        'sa'          => [
            'name'     => 'Sanskrit',
            'script'   => 'Deva',
            'dir'      => 'ltr',
            'native'   => 'संस्कृतम्',
            'regional' => 'sa_IN',
        ],
        'sah'         => [
            'name'     => 'Yakut',
            'script'   => 'Cyrl',
            'dir'      => 'ltr',
            'native'   => 'Саха тыла',
            'regional' => '',
        ],
        'saq'         => [
            'name'     => 'Samburu',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Kisampur',
            'regional' => '',
        ],
        'sbp'         => [
            'name'     => 'Sileibi',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Ishisangu',
            'regional' => '',
        ],
        'sc'          => [
            'name'     => 'Sardinian',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Sardu',
            'regional' => 'sc_IT',
        ],
        'sd'          => [
            'name'     => 'Sindhi',
            'script'   => 'Arab',
            'dir'      => 'rtl',
            'native'   => 'سنڌي',
            'regional' => 'sd_IN',
        ],
        'se'          => [
            'name'     => 'Northern Sami',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Davvisámegiella',
            'regional' => 'se_NO',
        ],
        'seh'         => [
            'name'     => 'Sena',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Sena',
            'regional' => '',
        ],
        'ses'         => [
            'name'     => 'Songhay',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Koyraboro senni',
            'regional' => '',
        ],
        'sg'          => [
            'name'     => 'Sango',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Sängö',
            'regional' => '',
        ],
        'sh'          => [
            'name'     => 'Serbo-Croatian',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Srpskohrvatski',
            'regional' => '',
        ],
        'shi'         => [
            'name'     => 'Tachelhit (Latin)',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Tashelhit',
            'regional' => '',
        ],
        'shi-Tfng'    => [
            'name'     => 'Tachelhit (Tifinagh)',
            'script'   => 'Tfng',
            'dir'      => 'rtl',
            'native'   => 'ⵜⴰⵎⴰⵣⵉⵖⵜ',
            'regional' => '',
        ],
        'si'          => [
            'name'     => 'Sinhala',
            'script'   => 'Sinh',
            'dir'      => 'ltr',
            'native'   => 'සිංහල',
            'regional' => 'si_LK',
        ],
        'sid'         => [
            'name'     => 'Sidamo',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Sidaamu Afo',
            'regional' => 'sid_ET',
        ],
        'sk'          => [
            'name'     => 'Slovak',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Slovenčina',
            'regional' => 'sk_SK',
        ],
        'sl'          => [
            'name'     => 'Slovene',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Slovenščina',
            'regional' => 'sl_SI',
        ],
        'sm'          => [
            'name'     => 'Samoan',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Gagana fa’a Sāmoa',
            'regional' => '',
        ],
        'sn'          => [
            'name'     => 'Shona',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'ChiShona',
            'regional' => '',
        ],
        'so'          => [
            'name'     => 'Somali',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Soomaali',
            'regional' => 'so_SO',
        ],
        'sq'          => [
            'name'     => 'Albanian',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Shqip',
            'regional' => 'sq_AL',
        ],
        'sr'          => [
            'name'     => 'Serbian (Cyrillic)',
            'script'   => 'Cyrl',
            'dir'      => 'ltr',
            'native'   => 'Српски',
            'regional' => 'sr_RS',
        ],
        'sr-Latin'    => [
            'name'     => 'Serbian (Latin)',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Srpski',
            'regional' => 'sr_RS',
        ],
        'ss'          => [
            'name'     => 'Swati',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Siswati',
            'regional' => 'ss_ZA',
        ],
        'ssy'         => [
            'name'     => 'Saho',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Saho',
            'regional' => '',
        ],
        'st'          => [
            'name'     => 'Southern Sotho',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Sesotho',
            'regional' => 'st_ZA',
        ],
        'su'          => [
            'name'     => 'Sundanese',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Basa Sunda',
            'regional' => '',
        ],
        'sv'          => [
            'name'     => 'Swedish',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Svenska',
            'regional' => 'sv_SE',
        ],
        'sw'          => [
            'name'     => 'Swahili',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Kiswahili',
            'regional' => 'sw_KE',
        ],
        'swc'         => [
            'name'     => 'Congo Swahili',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Kiswahili ya Kongo',
            'regional' => '',
        ],

        // T
        //====================================================>
        'ta'          => [
            'name'     => 'Tamil',
            'script'   => 'Taml',
            'dir'      => 'ltr',
            'native'   => 'தமிழ்',
            'regional' => 'ta_IN',
        ],
        'te'          => [
            'name'     => 'Telugu',
            'script'   => 'Telu',
            'dir'      => 'ltr',
            'native'   => 'తెలుగు',
            'regional' => 'te_IN',
        ],
        'teo'         => [
            'name'     => 'Teso',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Kiteso',
            'regional' => '',
        ],
        'tg'          => [
            'name'     => 'Tajik (Cyrillic)',
            'script'   => 'Cyrl',
            'dir'      => 'ltr',
            'native'   => 'Тоҷикӣ',
            'regional' => 'tg_TJ',
        ],
        'tg-Arab'     => [
            'name'     => 'Tajik (Arabic)',
            'script'   => 'Arab',
            'dir'      => 'rtl',
            'native'   => 'تاجیکی',
            'regional' => 'tg_TJ',
        ],
        'tg-Latin'    => [
            'name'     => 'Tajik (Latin)',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Tojikī',
            'regional' => 'tg_TJ',
        ],
        'th'          => [
            'name'     => 'Thai',
            'script'   => 'Thai',
            'dir'      => 'ltr',
            'native'   => 'ไทย',
            'regional' => 'th_TH',
        ],
        'ti'          => [
            'name'     => 'Tigrinya',
            'script'   => 'Ethi',
            'dir'      => 'ltr',
            'native'   => 'ትግርኛ',
            'regional' => 'ti_ET',
        ],
        'tig'         => [
            'name'     => 'Tigre',
            'script'   => 'Ethi',
            'dir'      => 'ltr',
            'native'   => 'ትግረ',
            'regional' => 'tig_ER',
        ],
        'tk'          => [
            'name'     => 'Turkmen',
            'script'   => 'Cyrl',
            'dir'      => 'ltr',
            'native'   => 'Түркменче',
            'regional' => 'tk_TM',
        ],
        'tl'          => [
            'name'     => 'Tagalog',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Tagalog',
            'regional' => 'tl_PH',
        ],
        'tn'          => [
            'name'     => 'Tswana',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Setswana',
            'regional' => 'tn_ZA',
        ],
        'to'          => [
            'name'     => 'Tongan',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Lea fakatonga',
            'regional' => '',
        ],
        'tr'          => [
            'name'     => 'Turkish',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Türkçe',
            'regional' => 'tr_TR',
        ],
        'trv'         => [
            'name'     => 'Taroko',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Seediq',
            'regional' => '',
        ],
        'ts'          => [
            'name'     => 'Tsonga',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Xitsonga',
            'regional' => 'ts_ZA',
        ],
        'tt'          => [
            'name'     => 'Tatar',
            'script'   => 'Cyrl',
            'dir'      => 'ltr',
            'native'   => 'Татар теле',
            'regional' => 'tt_RU',
        ],
        'tw'          => [
            'name'     => 'Twi',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Twi',
            'regional' => '',
        ],
        'twq'         => [
            'name'     => 'Tasawaq',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Tasawaq senni',
            'regional' => '',
        ],
        'ty'          => [
            'name'     => 'Tahitian',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Reo Māohi',
            'regional' => '',
        ],
        'tzm'         => [
            'name'     => 'Central Atlas Tamazight (Tifinagh)',
            'script'   => 'Tfng',
            'dir'      => 'rtl',
            'native'   => 'ⵜⴰⵎⴰⵣⵉⵖⵜ',
            'regional' => '',
        ],
        'tzm-Latin'   => [
            'name'     => 'Central Atlas Tamazight (Latin)',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Tamazight',
            'regional' => '',
        ],

        // U
        //====================================================>
        'ug'          => [
            'name'     => 'Uyghur',
            'script'   => 'Arab',
            'dir'      => 'rtl',
            'native'   => 'ئۇيغۇرچە',
            'regional' => 'ug_CN',
        ],
        'uk'          => [
            'name'     => 'Ukrainian',
            'script'   => 'Cyrl',
            'dir'      => 'ltr',
            'native'   => 'Українська',
            'regional' => 'uk_UA',
        ],
        'ur'          => [
            'name'     => 'Urdu',
            'script'   => 'Arab',
            'dir'      => 'rtl',
            'native'   => 'اردو',
            'regional' => 'ur_PK',
        ],
        'uz'          => [
            'name'     => 'Uzbek (Cyrillic)',
            'script'   => 'Cyrl',
            'dir'      => 'ltr',
            'native'   => 'Ўзбек',
            'regional' => 'uz_UZ',
        ],
        'uz-Arab'     => [
            'name'     => 'Uzbek (Arabic)',
            'script'   => 'Arab',
            'dir'      => 'rtl',
            'native'   => 'اۉزبېک',
            'regional' => '',
        ],
        'uz-Latin'    => [
            'name'     => 'Uzbek (Latin)',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Oʼzbekcha',
            'regional' => 'uz_UZ',
        ],

        // V
        //====================================================>
        'vai'         => [
            'name'     => 'Vai (Vai)',
            'script'   => 'Vaii',
            'dir'      => 'ltr',
            'native'   => 'ꕙꔤ',
            'regional' => '',
        ],
        'vai-Latin'   => [
            'name'     => 'Vai (Latin)',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Viyamíĩ',
            'regional' => '',
        ],
        've'          => [
            'name'     => 'Venda',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Tshivenḓa',
            'regional' => 've_ZA',
        ],
        'vi'          => [
            'name'     => 'Vietnamese',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Tiếng Việt',
            'regional' => 'vi_VN',
        ],
        'vo'          => [
            'name'     => 'Volapük',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Volapük',
            'regional' => '',
        ],

        // W
        //====================================================>
        'wa'          => [
            'name'     => 'Walloon',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Walon',
            'regional' => 'wa_BE',
        ],
        'wae'         => [
            'name'     => 'Walser',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Walser',
            'regional' => 'wae_CH',
        ],
        'wal'         => [
            'name'     => 'Wolaytta',
            'script'   => 'Ethi',
            'dir'      => 'ltr',
            'native'   => 'ወላይታቱ',
            'regional' => 'wal_ET',
        ],
        'wen'         => [
            'name'     => 'Sorbian',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Wendic',
            'regional' => '',
        ],
        'wo'          => [
            'name'     => 'Wolof',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Wolof',
            'regional' => 'wo_SN',
        ],

        // X
        //====================================================>
        'xh'          => [
            'name'     => 'Xhosa',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'IsiXhosa',
            'regional' => 'xh_ZA',
        ],
        'xog'         => [
            'name'     => 'Soga',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Olusoga',
            'regional' => '',
        ],

        // Y
        //====================================================>
        'yav'         => [
            'name'     => 'Yangben',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Nuasue',
            'regional' => '',
        ],
        'yi'          => [
            'name'     => 'Yiddish',
            'script'   => 'Hebr',
            'dir'      => 'rtl',
            'native'   => 'ייִדיש',
            'regional' => 'yi_US',
        ],
        'yo'          => [
            'name'     => 'Yoruba',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'Èdè Yorùbá',
            'regional' => 'yo_NG',
        ],
        'yue'         => [
            'name'     => 'Yue',
            'script'   => 'Hant',
            'dir'      => 'ltr',
            'native'   => '廣州話',
            'regional' => 'yue_HK',
        ],

        // Z
        //====================================================>
        'zh'          => [
            'name'     => 'Chinese (Simplified)',
            'script'   => 'Hans',
            'dir'      => 'ltr',
            'native'   => '简体中文',
            'regional' => 'zh_CN',
        ],
        'zh-Hant'     => [
            'name'     => 'Chinese (Traditional)',
            'script'   => 'Hant',
            'dir'      => 'ltr',
            'native'   => '繁體中文',
            'regional' => 'zh_CN',
        ],
        'zu'          => [
            'name'     => 'Zulu',
            'script'   => 'Latn',
            'dir'      => 'ltr',
            'native'   => 'IsiZulu',
            'regional' => 'zu_ZA',
        ],
    ],

];
