<div>

      <form wire:submit.prevent="onYoutubeChannelStatistics">

            <div>
                <!-- Session Status -->
                <x-auth-session-status class="mb-4" :status="session('status')" />
                                            
                <!-- Validation Errors -->
                <x-auth-validation-errors class="mb-4" :errors="$errors" />
            </div>
    
            <div class="row mb-3">
                <label class="form-label">{{ __('Enter YouTube Channel URL') }}</label>
                <div class="col">
                    <div class="input-group input-group-flat">
                        <input type="text" id="input" class="form-control" wire:model.defer="link" placeholder="https://..." required />
                        <span class="input-group-text">
                            <div id="paste" class="cursor-pointer" title="{{ __('Paste') }}" data-bs-original-title="{{ __('Paste') }}" data-bs-toggle="tooltip" wire:ignore>
                              <i class="far fa-clipboard fa-fw"></i>
                            </div>
                        </span>
                    </div>
                </div>
            </div>

            @if ( \App\Models\Admin\General::first()->captcha_status )
              <x-public.recaptcha />
            @endif

            <div class="form-group text-center mb-0">
                <button class="btn bg-gradient-info mb-0" wire:loading.attr="disabled">
                    <span>
                        <div wire:loading.inline wire:target="onYoutubeChannelStatistics">
                            <x-loading />
                        </div>
                        <span wire:target="onYoutubeChannelStatistics">{{ __('Statistic') }}</span>
                    </span>
                </button>

                <button class="btn bg-gradient-success mb-0" wire:click.prevent="onSample" wire:loading.attr="disabled">
                  <span>
                    <div wire:loading.inline wire:target="onSample">
                      <x-loading />
                    </div>
                    <span wire:target="onSample">{{ __('Sample') }}</span>
                  </span>
                </button>

                <button class="btn bg-gradient-warning mb-0" wire:click.prevent="onReset" wire:loading.attr="disabled">
                  <span>
                    <div wire:loading.inline wire:target="onReset">
                      <x-loading />
                    </div>
                    <span wire:target="onReset">{{ __('Reset') }}</span>
                  </span>
                </button>
            </div>

            @if ( !empty($data) )
                <div class="table-responsive mt-3">
                    <table class="table table-hover table-bordered table-striped border mb-0">
                        <thead class="bg-gradient-success">
                            <tr>
                                <th colspan="2" class="text-center text-white h6">{{ __('Results') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td class="bg-gradient-success text-white">{{ __('Thumbnail') }}</td>
                                <td><img src="{{ $data['thumbnail'] }}" class="ms-0" /></td>
                            </tr>

                            <tr>
                                <td class="bg-gradient-success text-white w-25">{{ __('Channel Title') }}</td>
                                <td>{{ $data['channelTitle'] }}</td>
                            </tr>

                            <tr>
                                <td class="bg-gradient-success text-white">{{ __('Channel ID') }}</td>
                                <td>{{ $data['channelId'] }}</td>
                            </tr>

                            <tr>
                                <td class="bg-gradient-success text-white">{{ __('Published at') }}</td>
                                <td>{{ $data['publishedAt'] }}</td>
                            </tr>

                            <tr>
                                <td class="bg-gradient-success text-white">{{ __('Total Views') }}</td>
                                <td>{{ number_format( $data['viewCount'] ) }}</td>
                            </tr>

                            <tr>
                                <td class="bg-gradient-success text-white">{{ __('Total Subscribers') }}</td>
                                <td>{{ number_format( $data['subscriberCount'] ) }}</td>
                            </tr>

                            <tr>
                                <td class="bg-gradient-success text-white">{{ __('Total Videos') }}</td>
                                <td>{{ number_format( $data['videoCount'] ) }}</td>
                            </tr>

                            <tr>
                                <td class="bg-gradient-success text-white">{{ __('Country') }}</td>
                                <td>{{ $data['country'] }}</td>
                            </tr>

                            <tr>
                                <td class="bg-gradient-success text-white">{{ __('Description') }}</td>
                                <td>{{ $data['description'] }}</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            @endif

      </form>

      <script>
        (function( $ ) {
          "use strict";

              document.addEventListener('livewire:load', function () {

                  var el      = document.getElementById('paste');
                  var input   = document.getElementById('input');
                  var tooltip = new bootstrap.Tooltip(el);

                  var pasteIcon = '<i class="far fa-clipboard fa-fw"></i>';
                  var clearIcon = '<i class="fas fa-trash fa-fw"></i>';

                  function setPasteIcon() {
                    el.innerHTML = pasteIcon;
                    tooltip.dispose();
                    el.setAttribute('title', '{{ __('Paste') }}');
                    el.classList.remove('text-danger');
                    tooltip = new bootstrap.Tooltip(el);
                  }

                  function setClearIcon() {
                    el.innerHTML = clearIcon;
                    tooltip.dispose();
                    el.setAttribute('title', '{{ __('Clear') }}');
                    el.classList.add('text-danger');
                    tooltip = new bootstrap.Tooltip(el);
                  }

                  function checkInputValue() {
                    if (input.value) {
                      setClearIcon();
                    } else {
                      setPasteIcon();
                    }
                  }

                  checkInputValue(); // Initial check in case there's a value already

                  // Handle click on the icon
                  el.addEventListener('click', function() {
                    if (el.innerHTML === clearIcon) {
                      // Clear action
                      @this.set('link', ''); // Update Livewire state
                      setPasteIcon();
                    } else {
                      // Paste action
                      navigator.clipboard.readText().then(function(clipText) {
                        @this.set('link', clipText);
                        setClearIcon();
                      }).catch(function() {
                        // Handle error if needed
                      });
                    }
                  });

                  // Handle changes to the input field
                  input.addEventListener('input', checkInputValue);

              });

        })( jQuery );
      </script>
</div>