<?php

namespace App\Http\Livewire\Public\Tools;

use Livewire\Component;
use App\Models\Admin\History;
use Illuminate\Support\Facades\Http;
use App\Classes\YoutubeRegionRestrictionCheckerClass;
use DateTime;
use GeoIp2\Database\Reader;
use GeoIp2\Exception\AddressNotFoundException;
use App\Rules\VerifyRecaptcha;
use App\Models\Admin\General;

class YoutubeRegionRestrictionChecker extends Component
{

    protected $listeners = ['onSetCountries'];
    public $link;
    public $data = [];

    public $allowed;
    public $blocked;
    public $recaptcha;

    public function render()
    {
        return view('livewire.public.tools.youtube-region-restriction-checker');
    }

    /**
     * -------------------------------------------------------------------------------
     *  onSetCountries
     * -------------------------------------------------------------------------------
    **/
    public function onSetCountries( $allowed, $blocked )
    {

        $this->allowed = $allowed;
        $this->blocked = $blocked;

    }

    /**
     * -------------------------------------------------------------------------------
     *  onYoutubeRegionRestrictionChecker
     * -------------------------------------------------------------------------------
    **/
    public function onYoutubeRegionRestrictionChecker(){

        $validationRules = [
            'link' => 'required'
        ];

        if (General::first()->captcha_status) {
            $validationRules['recaptcha'] = ['required', new VerifyRecaptcha];
        }

        $this->validate($validationRules);

        $this->data = null;

        try {

                $output = new YoutubeRegionRestrictionCheckerClass();

                $this->data = $output->get_data( $this->link );

                $this->dispatchBrowserEvent('data', $this->data);

                $this->dispatchBrowserEvent('resetReCaptcha');

        } catch (\Exception $e) {

            $this->addError('error', __($e->getMessage()));
        }

        //Save History
        if ( !empty($this->data) ) {

            $history             = new History;
            $history->tool_name  = 'YouTube Region Restriction Checker';
            $history->client_ip  = request()->ip();

            require app_path('Classes/geoip2.phar');

            $reader = new Reader( app_path('Classes/GeoLite2-City.mmdb') );

            try {

                $record           = $reader->city( request()->ip() );

                $history->flag    = strtolower( $record->country->isoCode );
                
                $history->country = strip_tags( $record->country->name );

            } catch (AddressNotFoundException $e) {

            }

            $history->created_at = new DateTime();
            $history->save();
        }

    }

    /**
     * -------------------------------------------------------------------------------
     *  onSample
     * -------------------------------------------------------------------------------
    **/
    public function onSample()
    {
        $this->link = 'https://www.youtube.com/watch?v=K4DyBUG242c';
    }

    /**
     * -------------------------------------------------------------------------------
     *  onReset
     * -------------------------------------------------------------------------------
    **/
    public function onReset()
    {
        $this->link = null;
        $this->data = [];
    }
}
